library(ggplot2)
library(grid) 

# Fungsi menggambar node
draw_cpm_node_layers <- function(center_x, center_y, node_label, est, lst, radius = 4, visible = TRUE, border_width = 0.05, line_width = 0.05) {
  
  if (!visible) {
    return(list(
      geom_point(aes(x = center_x, y = center_y), color = NA)  # titik dummy
    ))
  }
  
  circle_df <- data.frame(
    angle = seq(0, 2 * pi, length.out = 100)
  ) |>
    transform(
      x = center_x + radius * cos(angle),
      y = center_y + radius * sin(angle)
    )
  
  list(
    geom_polygon(data = circle_df, aes(x, y), fill = "white", color = "black", line_width=border_width),
    geom_segment(aes(x = center_x, y = center_y - radius, xend = center_x, yend = center_y + radius), color = "black", linewidth = line_width),
    geom_segment(aes(x = center_x, y = center_y, xend = center_x + radius, yend = center_y), color = "black", linewidth = line_width),
    annotate("text", x = center_x - radius * 0.5, y = center_y, label = node_label, fontface = "bold", size = 2.5),
    annotate("text", x = center_x + radius * 0.4, y = center_y + radius * 0.3, label = est, size = 1.8),
    annotate("text", x = center_x + radius * 0.4, y = center_y - radius * 0.3, label = lst, size = 1.8)
  )
}

# Membuat garis
draw_arrow <- function(x_start, y_start, x_end, y_end,
                       label_top = NULL, label_bottom = NULL,
                       style = "solid",         # "solid", "dashed", "double"
                       arrowhead = "closed"     # "closed", "open", "none"
) {
  
  # Tentukan tipe garis
  line_type <- switch(style,
                      "solid" = "solid",
                      "dashed" = "dashed",
                      "double" = "solid")  # untuk garis utama
  
  # Tentukan bentuk ujung panah
  arrow_obj <- switch(arrowhead,
                      "closed" = arrow(length = unit(0.2, "cm"), type = "closed"),
                      "open"   = arrow(length = unit(0.15, "cm"), type = "open"),
                      "none"   = NULL,
                      arrow(length = unit(0.25, "cm"), type = "closed"))  # default
  
  # Posisi label
  label_x <- (x_start + x_end) / 2
  label_y <- (y_start + y_end) / 2
  
  layers <- list()
  
  #Garis Utama
  if (style == "double") {
    dx <- x_end - x_start
    dy <- y_end - y_start
    length_factor <- 0.97
    x_end_short <- x_start + dx * length_factor
    y_end_short <- y_start + dy * length_factor
    
    # Hitung vektor tegak lurus (normal vector) untuk offset
    mag <- sqrt(dx^2 + dy^2)
    nx <- -dy / mag
    ny <- dx / mag
    offset <- 0.5 # besar offset double line
    offset_x <- nx * offset
    offset_y <- ny * offset
    
    # Garis bayangan kanan
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start + offset_x, y = y_start + offset_y,
          xend = x_end_short + offset_x, yend = y_end_short + offset_y),
      linetype = line_type,
      color = "black",
      linewidth = 0.3
    )
    
    # Garis bayangan kiri
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start - offset_x, y = y_start - offset_y,
          xend = x_end_short - offset_x, yend = y_end_short - offset_y),
      linetype = line_type,
      color = "black",
      linewidth = 0.3
    )
    
    # Garis utama tebal di tengah dengan panah
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start, y = y_start, xend = x_end, yend = y_end),
      arrow = arrow_obj,
      linetype = line_type,
      color = "black",
      linewidth = 0.7
    )

    layers[[length(layers) + 1]] <- ggforce::geom_arc_bar(
      aes(x0 = x_start, y0 = y_start, r0 = 0, r = offset + 0.1,
          start = atan2(dy, dx) + pi / 2, end = atan2(dy, dx) - pi / 2),
      fill = "black",
      color = NA
    )
    
  } else {
    # Garis normal (solid/dashed)
    line_width <- ifelse(style == "dashed", 0.3, 0.5)
    
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start, y = y_start, xend = x_end, yend = y_end),
      arrow = arrow_obj,
      linetype = line_type,
      color = "black",
      linewidth = line_width
    )
  }
  
  # Label atas
  if (!is.null(label_top)) {
    layers[[length(layers) + 1]] <- annotate("text", x = label_x, y = label_y + 3,
                                             label = label_top, fontface = "bold", color = "black", size = 2.5)
  }
  
  # Label bawah
  if (!is.null(label_bottom)) {
    layers[[length(layers) + 1]] <- annotate("text", x = label_x, y = label_y - 3,
                                             label = label_bottom, color = "black", size = 2.5)
  }
  
  return(layers)
}

# Posisi node
nodes <- data.frame(
  id = c("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64"),
  est = c("0", "8", "271", "53", "29", "21", "32", "56", "35", "59", "56", "80", "83", "75", "104", "107", "105", "137", "140", "122", "161", "164", "152", "194", "197", "168", "218", "221", "198", "251", "254", "227", "257", "260", "212", "268", "270", "227", "270", "288", "278", "157", "129", "154", "179", "204", "225", "194", "224", "254", "284", "178", "204", "230", "256", "182", "203", "224", "245", "242", "259", "0", "239", "0", "300"),
  lst = c("0", "8", "288", "80", "29", "79", "32", "56", "93", "59", "114", "80", "83", "133", "104", "107", "163", "137", "140", "180", "161", "164", "210", "194", "197", "226", "218", "221", "256", "251", "254", "237", "267", "270", "270", "268", "270", "288", "286", "288", "288", "286", "190", "215", "240", "265", "286", "296", "226", "256", "286", "210", "236", "262", "288", "225", "246", "267", "288", "288", "288", "270", "0", "0", "300"),
  x <- c(0, 16, 328, 68, 32, 32, 48, 64, 64, 80, 96, 96, 112, 128, 128, 144, 160, 160, 176, 192, 192, 208, 224, 224, 240, 256, 256, 272, 288, 288, 304, 272, 304, 320, 320, 320, 336, 352, 352, 368, 344, 304, 172, 208, 256, 288, 320, 240, 280, 320, 336, 256, 288, 320, 352, 240, 280, 320, 352, 332, 352, 320, 344, 320, 384),
  y <- c(0, 0, -108, -24, 0, 68, 16, 16, 68, 0, 68, 0, -16, 68, -16, 0, 68, 0, 16, 68, 16, 0, 68, 0, -16, 68, -16, 0, 68, 0, 16, -28, -28, -12, 68, 16, 0, 68, 0, 0, 12, -68, -80, -80, -80, -80, -80, -60, -60, -60, -12, 88, 88, 88, 88, 56, 56, 56, 56, 28, 36, -44, 48, -92, 0)
)

# Buat plot kosong
p <- ggplot() + coord_fixed() + theme_void()

# Tambahkan semua node ke plot
for (i in seq_len(nrow(nodes))) {
  p <- p + draw_cpm_node_layers(nodes$x[i], nodes$y[i], nodes$id[i], nodes$est[i], nodes$lst[i], , border_width = 0.02, line_width = 0.05)
}
# Node dummy 
dummy_node <- draw_cpm_node_layers(24, -100, "", est = "", lst = "", visible = FALSE)

# Tambahkan panah (edge) antar node sesuai urutan
p <- p +
  draw_arrow(nodes$x[which(nodes$id == "0")] + 4, nodes$y[which(nodes$id == "0")], nodes$x[which(nodes$id == "1")] - 4, nodes$y[which(nodes$id == "1")], label_top = "A", label_bottom = "8", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "1")] + 4, nodes$y[which(nodes$id == "1")], nodes$x[which(nodes$id == "4")] - 4, nodes$y[which(nodes$id == "4")], label_top = "d1", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "4")] + 4, nodes$y[which(nodes$id == "4")], nodes$x[which(nodes$id == "6")] - 4, nodes$y[which(nodes$id == "6")], label_top = "d3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "6")] + 4, nodes$y[which(nodes$id == "6")], nodes$x[which(nodes$id == "7")] - 4, nodes$y[which(nodes$id == "7")], label_top = "e2", label_bottom = "24", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "7")] + 4, nodes$y[which(nodes$id == "7")], nodes$x[which(nodes$id == "9")] - 4, nodes$y[which(nodes$id == "9")], label_top = "e3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "9")] + 4, nodes$y[which(nodes$id == "9")], nodes$x[which(nodes$id == "11")] - 4, nodes$y[which(nodes$id == "11")], label_top = "f2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "11")] + 4, nodes$y[which(nodes$id == "11")], nodes$x[which(nodes$id == "12")] - 4, nodes$y[which(nodes$id == "12")], label_top = "f3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "12")] + 4, nodes$y[which(nodes$id == "12")], nodes$x[which(nodes$id == "14")] - 4, nodes$y[which(nodes$id == "14")], label_top = "g2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "14")] + 4, nodes$y[which(nodes$id == "14")], nodes$x[which(nodes$id == "15")] - 4, nodes$y[which(nodes$id == "15")], label_top = "g3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "15")] + 4, nodes$y[which(nodes$id == "15")], nodes$x[which(nodes$id == "17")] - 4, nodes$y[which(nodes$id == "17")], label_top = "h2", label_bottom = "30", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "17")] + 4, nodes$y[which(nodes$id == "17")], nodes$x[which(nodes$id == "18")] - 4, nodes$y[which(nodes$id == "18")], label_top = "h3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "18")] + 4, nodes$y[which(nodes$id == "18")], nodes$x[which(nodes$id == "20")] - 4, nodes$y[which(nodes$id == "20")], label_top = "i2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "20")] + 4, nodes$y[which(nodes$id == "20")], nodes$x[which(nodes$id == "21")] - 4, nodes$y[which(nodes$id == "21")], label_top = "i3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "21")] + 4, nodes$y[which(nodes$id == "21")], nodes$x[which(nodes$id == "23")] - 4, nodes$y[which(nodes$id == "23")], label_top = "j2", label_bottom = "30", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "23")] + 4, nodes$y[which(nodes$id == "23")], nodes$x[which(nodes$id == "24")] - 4, nodes$y[which(nodes$id == "24")], label_top = "j3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "24")] + 4, nodes$y[which(nodes$id == "24")], nodes$x[which(nodes$id == "26")] - 4, nodes$y[which(nodes$id == "26")], label_top = "k2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "26")] + 4, nodes$y[which(nodes$id == "26")], nodes$x[which(nodes$id == "27")] - 4, nodes$y[which(nodes$id == "27")], label_top = "k3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "27")] + 4, nodes$y[which(nodes$id == "27")], nodes$x[which(nodes$id == "29")] - 4, nodes$y[which(nodes$id == "29")], label_top = "l2", label_bottom = "30", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "29")] + 4, nodes$y[which(nodes$id == "29")], nodes$x[which(nodes$id == "30")] - 4, nodes$y[which(nodes$id == "30")], label_top = "l3", label_bottom = "3", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "30")] + 4, nodes$y[which(nodes$id == "30")], nodes$x[which(nodes$id == "35")] - 4, nodes$y[which(nodes$id == "35")], label_top = "n2", label_bottom = "14", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "35")] + 4, nodes$y[which(nodes$id == "35")], nodes$x[which(nodes$id == "36")] - 4, nodes$y[which(nodes$id == "36")], label_top = "n3", label_bottom = "2", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "36")] + 4, nodes$y[which(nodes$id == "36")], nodes$x[which(nodes$id == "38")] - 4, nodes$y[which(nodes$id == "38")], label_top = "o2", label_bottom = "16", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "38")] + 4, nodes$y[which(nodes$id == "38")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], label_top = "o3", label_bottom = "2", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "39")] + 4, nodes$y[which(nodes$id == "39")], nodes$x[which(nodes$id == "64")] - 4, nodes$y[which(nodes$id == "64")], label_top = "AN", label_bottom = "12", style = "double") +
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 4, nodes$y[which(nodes$id == "1")], 32, -24, arrowhead = "none") +
  draw_arrow(32,-24,nodes$x[which(nodes$id == "3")] - 4, nodes$y[which(nodes$id == "3")], label_top = "C", label_bottom = "45", arrowhead = "open")+
  draw_arrow(nodes$x[which(nodes$id == "3")] + 4, nodes$y[which(nodes$id == "3")], nodes$x[which(nodes$id == "11")] - 4, nodes$y[which(nodes$id == "11")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 4, nodes$y[which(nodes$id == "1")], nodes$x[which(nodes$id == "5")] - 4, nodes$y[which(nodes$id == "5")], label_top = "d2", label_bottom = "13", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "5")] + 4, nodes$y[which(nodes$id == "5")], nodes$x[which(nodes$id == "8")] - 4, nodes$y[which(nodes$id == "8")], label_top = "e1", label_bottom = "14", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "8")] + 4, nodes$y[which(nodes$id == "8")], nodes$x[which(nodes$id == "10")] - 4, nodes$y[which(nodes$id == "10")], label_top = "f1", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "10")] + 4, nodes$y[which(nodes$id == "10")], nodes$x[which(nodes$id == "13")] - 4, nodes$y[which(nodes$id == "13")], label_top = "g1", label_bottom = "19", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "13")] + 4, nodes$y[which(nodes$id == "13")], nodes$x[which(nodes$id == "16")] - 4, nodes$y[which(nodes$id == "16")], label_top = "h1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "16")] + 4, nodes$y[which(nodes$id == "16")], nodes$x[which(nodes$id == "19")] - 4, nodes$y[which(nodes$id == "19")], label_top = "i1", label_bottom = "17", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "19")] + 4, nodes$y[which(nodes$id == "19")], nodes$x[which(nodes$id == "22")] - 4, nodes$y[which(nodes$id == "22")], label_top = "j1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "22")] + 4, nodes$y[which(nodes$id == "22")], nodes$x[which(nodes$id == "25")] - 4, nodes$y[which(nodes$id == "25")], label_top = "k1", label_bottom = "16", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "25")] + 4, nodes$y[which(nodes$id == "25")], nodes$x[which(nodes$id == "28")] - 4, nodes$y[which(nodes$id == "28")], label_top = "l1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "28")] + 4, nodes$y[which(nodes$id == "28")], nodes$x[which(nodes$id == "34")] - 4, nodes$y[which(nodes$id == "34")], label_top = "n1", label_bottom = "14", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "34")] + 4, nodes$y[which(nodes$id == "34")], nodes$x[which(nodes$id == "37")] - 4, nodes$y[which(nodes$id == "37")], label_top = "o1", label_bottom = "15", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "37")] + 4, nodes$y[which(nodes$id == "37")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "22")] + 4, nodes$y[which(nodes$id == "22")], nodes$x[which(nodes$id == "51")] - 4, nodes$y[which(nodes$id == "51")], label_top = "AA", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "51")] + 4, nodes$y[which(nodes$id == "51")], nodes$x[which(nodes$id == "52")] - 4, nodes$y[which(nodes$id == "52")], label_top = "AB", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "52")] + 4, nodes$y[which(nodes$id == "52")], nodes$x[which(nodes$id == "53")] - 4, nodes$y[which(nodes$id == "53")], label_top = "AC", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "53")] + 4, nodes$y[which(nodes$id == "53")], nodes$x[which(nodes$id == "54")] - 4, nodes$y[which(nodes$id == "54")], label_top = "AD", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "54")] + 4, nodes$y[which(nodes$id == "54")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "14")] + 4, nodes$y[which(nodes$id == "14")], 148, -80, label_top = "R", label_bottom = "25", arrowhead = "none") +
  draw_arrow(148,-80,nodes$x[which(nodes$id == "42")] - 4, nodes$y[which(nodes$id == "42")],label_top = "R", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "42")] + 4, nodes$y[which(nodes$id == "42")], nodes$x[which(nodes$id == "43")] - 4, nodes$y[which(nodes$id == "43")], label_top = "S", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "43")] + 4, nodes$y[which(nodes$id == "43")], nodes$x[which(nodes$id == "44")] - 4, nodes$y[which(nodes$id == "44")], label_top = "T", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "44")] + 4, nodes$y[which(nodes$id == "44")], nodes$x[which(nodes$id == "45")] - 4, nodes$y[which(nodes$id == "45")], label_top = "U", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "45")] + 4, nodes$y[which(nodes$id == "45")], nodes$x[which(nodes$id == "46")] - 4, nodes$y[which(nodes$id == "46")], label_top = "V", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "46")] + 4, nodes$y[which(nodes$id == "46")], nodes$x[which(nodes$id == "38")] - 4, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "42")] + 4, nodes$y[which(nodes$id == "42")], 184,-68, arrowhead = "none") +
  draw_arrow(184,-68, nodes$x[which(nodes$id == "41")] - 4, nodes$y[which(nodes$id == "41")], label_top = "Q", label_bottom = "28", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "41")] + 4, nodes$y[which(nodes$id == "41")], nodes$x[which(nodes$id == "46")] - 4, nodes$y[which(nodes$id == "46")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "44")] + 4, nodes$y[which(nodes$id == "44")], 266,-92, arrowhead = "none") +
  draw_arrow(266,-92,nodes$x[which(nodes$id == "63")] - 4, nodes$y[which(nodes$id == "63")], label_top = "AM", label_bottom = "40", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "63")] + 4, nodes$y[which(nodes$id == "63")], nodes$x[which(nodes$id == "64")] - 4, nodes$y[which(nodes$id == "64")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "15")]- 4, nodes$y[which(nodes$id == "15")], 152,-44, arrowhead = "none") +
  draw_arrow(152,-44,nodes$x[which(nodes$id == "61")]+ 4, nodes$y[which(nodes$id == "61")], label_top = "AK", label_bottom = "28", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "61")] + 4, nodes$y[which(nodes$id == "61")], nodes$x[which(nodes$id == "36")] - 4, nodes$y[which(nodes$id == "36")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "20")] + 4, nodes$y[which(nodes$id == "20")], 216, nodes$y[which(nodes$id == "55")], arrowhead = "none") +
  draw_arrow(216,nodes$y[which(nodes$id == "55")],nodes$x[which(nodes$id == "55")] - 4, nodes$y[which(nodes$id == "55")], label_top = "AE", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "55")] + 4, nodes$y[which(nodes$id == "55")], nodes$x[which(nodes$id == "56")] - 4, nodes$y[which(nodes$id == "56")], label_top = "AF", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "56")] + 4, nodes$y[which(nodes$id == "56")], nodes$x[which(nodes$id == "57")] - 4, nodes$y[which(nodes$id == "57")], label_top = "AG", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "57")] + 4, nodes$y[which(nodes$id == "57")], nodes$x[which(nodes$id == "58")] - 4, nodes$y[which(nodes$id == "58")], label_top = "AH", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "58")] + 4, nodes$y[which(nodes$id == "58")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "21")] + 4, nodes$y[which(nodes$id == "21")], nodes$x[which(nodes$id == "47")] - 4, nodes$y[which(nodes$id == "47")], label_top = "W", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "47")] + 4, nodes$y[which(nodes$id == "47")], nodes$x[which(nodes$id == "48")] - 4, nodes$y[which(nodes$id == "48")], label_top = "X", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "48")] + 4, nodes$y[which(nodes$id == "48")], nodes$x[which(nodes$id == "49")] - 4, nodes$y[which(nodes$id == "49")], label_top = "Y", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "49")] + 4, nodes$y[which(nodes$id == "49")], nodes$x[which(nodes$id == "50")], nodes$y[which(nodes$id == "50")] - 4, label_top = "Z", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "50")] + 4, nodes$y[which(nodes$id == "50")], nodes$x[which(nodes$id == "38")] - 4, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "23")] + 4, nodes$y[which(nodes$id == "23")], 250, 48, arrowhead = "none") +
  draw_arrow(250, 48,nodes$x[which(nodes$id == "62")] - 4, nodes$y[which(nodes$id == "62")], label_top = "AL", label_bottom = "45", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "62")] + 4, nodes$y[which(nodes$id == "62")], nodes$x[which(nodes$id == "60")] - 4, nodes$y[which(nodes$id == "60")], style = "dashed", arrowhead = "none") +
  draw_arrow(nodes$x[which(nodes$id == "60")] + 4, nodes$y[which(nodes$id == "60")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "24")] + 4, nodes$y[which(nodes$id == "24")], 248, nodes$y[which(nodes$id == "31")], arrowhead = "none") +
  draw_arrow(248, nodes$y[which(nodes$id == "31")], nodes$x[which(nodes$id == "31")] - 4, nodes$y[which(nodes$id == "31")], label_top = "m1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "31")] + 4, nodes$y[which(nodes$id == "31")], nodes$x[which(nodes$id == "32")] - 4, nodes$y[which(nodes$id == "32")], label_top = "m2", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "32")] + 4, nodes$y[which(nodes$id == "32")], nodes$x[which(nodes$id == "33")] - 4, nodes$y[which(nodes$id == "33")], label_top = "m3", label_bottom = "3", arrowhead = "open") +
  
  draw_arrow(nodes$x[which(nodes$id == "27")] + 4, nodes$y[which(nodes$id == "27")], 284, 36, arrowhead = "none") +
  draw_arrow(284, 36, nodes$x[which(nodes$id == "60")]- 4, nodes$y[which(nodes$id == "60")], label_top = "AJ", label_bottom = "38", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "60")] + 4, nodes$y[which(nodes$id == "60")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "27")] + 4, nodes$y[which(nodes$id == "27")], 288, 28, arrowhead = "none") +
  draw_arrow(288, 28, nodes$x[which(nodes$id == "59")] - 4, nodes$y[which(nodes$id == "59")], label_top = "AI", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "59")] + 4, nodes$y[which(nodes$id == "59")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "36")], nodes$y[which(nodes$id == "36")] + 4, nodes$x[which(nodes$id == "40")] - 4, nodes$y[which(nodes$id == "40")], label_top = "P", label_bottom = "8", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "40")] + 4, nodes$y[which(nodes$id == "40")], nodes$x[which(nodes$id == "39")] - 4, nodes$y[which(nodes$id == "39")], style = "dashed", arrowhead = "none")+
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 4, nodes$y[which(nodes$id == "1")], 38, -108, style = "solid", arrowhead = "none")+
  draw_arrow(38, -108, nodes$x[which(nodes$id == "2")] - 4, nodes$y[which(nodes$id == "2")], label_top = "B", label_bottom = "263", arrowhead = "open")+
  draw_arrow(nodes$x[which(nodes$id == "2")] + 4, nodes$y[which(nodes$id == "2")], nodes$x[which(nodes$id == "64")] - 4, nodes$y[which(nodes$id == "64")], style = "dashed", arrowhead = "none")

# Tampilkan plot
print(p)
