library(ggplot2)
library(grid)

# Fungsi menggambar satu node CPM berbentuk lingkaran bersekat
draw_cpm_node_layers <- function(center_x, center_y, node_label, est, lst, radius = 3, visible = TRUE, border_width = 0.05, line_width = 0.05) {
  
  if (!visible) {
    return(list(
      geom_point(aes(x = center_x, y = center_y), color = NA) 
    ))
  }
  
  circle_df <- data.frame(
    angle = seq(0, 2 * pi, length.out = 100)
  ) |>
    transform(
      x = center_x + radius * cos(angle),
      y = center_y + radius * sin(angle)
    )
  
  list(
    geom_polygon(data = circle_df, aes(x, y), fill = "white", color = "black", line_width=border_width),
    geom_segment(aes(x = center_x, y = center_y - radius, xend = center_x, yend = center_y + radius), color = "black", linewidth = line_width),
    geom_segment(aes(x = center_x, y = center_y, xend = center_x + radius, yend = center_y), color = "black", linewidth = line_width),
    annotate("text", x = center_x - radius * 0.5, y = center_y, label = node_label, fontface = "bold", size = 2),
    annotate("text", x = center_x + radius * 0.4, y = center_y + radius * 0.3, label = est, size = 1.5),
    annotate("text", x = center_x + radius * 0.4, y = center_y - radius * 0.3, label = lst, size = 1.5)
  )
}

# Membuat garis
draw_arrow <- function(x_start, y_start, x_end, y_end,
                       label_top = NULL, label_bottom = NULL,
                       style = "solid",         # "solid", "dashed", "dotdash", "double"
                       arrowhead = "closed",    # "closed", "open", "none"
                       color = "black",         # warna garis
                       linewidth = 0.5,
                       bend_at = NULL
) {
  
  # Mapping style ke linetype
  line_type <- switch(style,
                      "solid"   = "solid",
                      "dashed"  = "dashed",
                      "dotdash" = "dotdash",
                      "double"  = "solid",  # akan digambar 3 garis
                      "solid")  # default
  
  # Mapping arrowhead ke bentuk panah
  arrow_obj <- switch(arrowhead,
                      "closed" = arrow(length = unit(0.2, "cm"), type = "closed"),
                      "open"   = arrow(length = unit(0.15, "cm"), type = "open"),
                      "none"   = NULL,
                      arrow(length = unit(0.25, "cm"), type = "closed")) 
  
  # Posisi label
  label_x <- (x_start + x_end) / 2
  label_y <- (y_start + y_end) / 2
  
  layers <- list()
  # Garis Utama
  if (style == "double") {
    dx <- x_end - x_start
    dy <- y_end - y_start
    length_factor <- 0.97
    x_end_short <- x_start + dx * length_factor
    y_end_short <- y_start + dy * length_factor
    
    # Hitung vektor tegak lurus (normal vector) untuk offset
    mag <- sqrt(dx^2 + dy^2)
    nx <- -dy / mag
    ny <- dx / mag
    offset <- 0.5 # besar offset double line 
    offset_x <- nx * offset
    offset_y <- ny * offset
    
    # Garis bayangan kanan
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start + offset_x, y = y_start + offset_y,
          xend = x_end_short + offset_x, yend = y_end_short + offset_y),
      linetype = line_type,
      color = "black",
      linewidth = 0.3
    )
    
    # Garis bayangan kiri
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start - offset_x, y = y_start - offset_y,
          xend = x_end_short - offset_x, yend = y_end_short - offset_y),
      linetype = line_type,
      color = "black",
      linewidth = 0.3
    )
    
    # Garis utama tebal di tengah dengan panah
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start, y = y_start, xend = x_end, yend = y_end),
      arrow = arrow_obj,
      linetype = line_type,
      color = "black",
      linewidth = 0.7
    )
    
    # Tambahkan setengah lingkaran (ekor) di titik awal
    layers[[length(layers) + 1]] <- ggforce::geom_arc_bar(
      aes(x0 = x_start, y0 = y_start, r0 = 0, r = offset + 0.1,
          start = atan2(dy, dx) + pi / 2, end = atan2(dy, dx) - pi / 2),
      fill = "black",
      color = NA
    )
    
  } else {
    # Garis normal (solid, dashed, dotdash)
    layers[[length(layers) + 1]] <- geom_segment(
      aes(x = x_start, y = y_start, xend = x_end, yend = y_end),
      arrow = arrow_obj,
      linetype = line_type,
      color = color,
      linewidth = linewidth
    )
  }
  # Label atas
  if (!is.null(label_top)) {
    layers[[length(layers) + 1]] <- annotate("text", x = label_x, y = label_y + 2,
                                             label = label_top, fontface = "bold", color = color, size = 2.5)
  }
  
  # Label bawah
  if (!is.null(label_bottom)) {
    layers[[length(layers) + 1]] <- annotate("text", x = label_x, y = label_y - 2,
                                             label = label_bottom, color = color, size = 2.5)
  }
  
  return(layers)
}

# Tabel 2x2
draw_box_grid <- function(center_x, center_y, values, box_size = 1,
                          text_size = 5, fontface_matrix = NULL,
                          line_type = "dotted") {
  # Hitung koordinat tepi kotak
  half_size <- box_size / 2
  left   <- center_x - half_size
  right  <- center_x + half_size
  top    <- center_y + half_size
  bottom <- center_y - half_size
  mid_x  <- center_x
  mid_y  <- center_y
  
  # Posisi koordinat teks di setiap sel 2x2
  text_df <- data.frame(
    x = c(left + box_size/4, right - box_size/4, left + box_size/4, right - box_size/4),
    y = c(top - box_size/4, top - box_size/4, bottom + box_size/4, bottom + box_size/4),
    label = as.vector(values),
    fontface = as.vector(if (!is.null(fontface_matrix)) fontface_matrix else rep("plain", 4))
  )
  
  list(
    # Kotak luar
    geom_rect(aes(xmin = left, xmax = right, ymin = bottom, ymax = top),
              fill = NA, color = "black", linetype = line_type, linewidth = 0.02),
    
    # Garis horizontal tengah
    geom_segment(aes(x = left, xend = right, y = mid_y, yend = mid_y), linetype = line_type, linewidth = 0.02),
    
    # Garis vertikal tengah
    geom_segment(aes(x = mid_x, xend = mid_x, y = bottom, yend = top), linetype = line_type, linewidth = 0.02),
    
    # Teks
    geom_text(data = text_df, aes(x = x, y = y, label = label, fontface = fontface),
              size = text_size)
  )
}

# Posisi node
nodes <- data.frame(
  id = c("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64"),
  est = c("0", "8", "240", "53", "29", "21", "32", "53", "45", "56", "66", "74", "77", "85", "95", "77", "115", "125", "98", "132", "146", "128", "162", "176", "149", "178", "197", "179", "208", "227", "200", "206", "236", "239", "222", "241", "229", "237", "257", "243", "249", "148", "120", "145", "170", "195", "216", "158", "188", "218", "2488", "158", "184", "210", "236", "167", "188", "219", "230", "200", "217", "123", "221", "235", "269"),
  lst = c("0", "8", "269", "74", "29", "27", "29", "53", "51", "53", "72", "74", "74", "91", "95", "95", "121", "125", "125", "138", "146", "146", "168", "176", "176", "184", "197", "197", "214", "227", "227", "209", "238", "241", "228", "241", "241", "243", "257", "257", "257", "257", "161", "186", "211", "236", "257", "197", "227", "257", "257", "179", "205", "231", "257", "194", "215", "236", "257", "257", "257", "241", "257", "263", "269"),
  x <- c(0,12,222,53,33,26,30,53,50,44,73,73,67,93,93,87,113,113,107,133,133,127,153,153,147,173,173,173,193,193,193,182,202,216,216,213,207,247,253,225,239,202,119,142,173,193,216,162,188,216,228,161,184,216,247,158,187,216,247,228,247,216,241,216,268),
  y <- c(0, 0, -81, -18, 0, 54, 18, 0, 54, -12, 54, 0, 18, 54, 0, -18, 54, 0, 18, 54, 0, -18, 54, 0, 18, 54, 0, 18, 54, 0, -12, -21, -21, -9, 54, 0, 12, 54, 0, 12, 9, -51, -60, -60, -60, -60, -60, -45, -45, -45, -9, 69, 69, 69, 69, 45, 45, 45, 45, 21, 27, -33, 36, -69, 0)

)

# Buat plot kosong
p <- ggplot() + coord_fixed() + theme_void()


# Tambahkan semua node ke plot
for (i in seq_len(nrow(nodes))) {
  p <- p + draw_cpm_node_layers(nodes$x[i], nodes$y[i], nodes$id[i], nodes$est[i], nodes$lst[i], border_width = 0.02, line_width = 0.05)
}


# Node dummy
dummy_node <- draw_cpm_node_layers(24, -100, "", est = "", lst = "", visible = FALSE)

# Tambahkan panah (edge) antar node sesuai urutan
p <- p +
  draw_arrow(nodes$x[which(nodes$id == "0")] + 3, nodes$y[which(nodes$id == "0")], nodes$x[which(nodes$id == "1")] - 3, nodes$y[which(nodes$id == "1")], label_top = "A", label_bottom = "8", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "1")] + 3, nodes$y[which(nodes$id == "1")], nodes$x[which(nodes$id == "4")] - 3, nodes$y[which(nodes$id == "4")], label_top = "d1", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "4")] + 3, nodes$y[which(nodes$id == "4")], nodes$x[which(nodes$id == "7")] - 3, nodes$y[which(nodes$id == "7")], label_top = "e2", label_bottom = "24", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "7")] + 3, nodes$y[which(nodes$id == "7")], nodes$x[which(nodes$id == "11")] - 3, nodes$y[which(nodes$id == "11")], label_top = "f2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "11")] + 3, nodes$y[which(nodes$id == "11")], nodes$x[which(nodes$id == "14")] - 3, nodes$y[which(nodes$id == "14")], label_top = "g2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "14")] + 3, nodes$y[which(nodes$id == "14")], nodes$x[which(nodes$id == "17")] - 3, nodes$y[which(nodes$id == "17")], label_top = "h2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "17")] + 3, nodes$y[which(nodes$id == "17")], nodes$x[which(nodes$id == "20")] - 3, nodes$y[which(nodes$id == "20")], label_top = "i2", label_bottom = "30", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "20")] + 3, nodes$y[which(nodes$id == "20")], nodes$x[which(nodes$id == "23")] - 3, nodes$y[which(nodes$id == "23")], label_top = "j2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "23")] + 3, nodes$y[which(nodes$id == "23")], nodes$x[which(nodes$id == "26")] - 3, nodes$y[which(nodes$id == "26")], label_top = "k2", label_bottom = "21", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "26")] + 3, nodes$y[which(nodes$id == "26")], nodes$x[which(nodes$id == "29")] - 3, nodes$y[which(nodes$id == "29")], label_top = "l2", label_bottom = "30", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "29")] + 3, nodes$y[which(nodes$id == "29")], nodes$x[which(nodes$id == "35")] - 3, nodes$y[which(nodes$id == "35")], label_top = "n3", label_bottom = "14", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "35")] + 3, nodes$y[which(nodes$id == "35")], nodes$x[which(nodes$id == "38")] - 3, nodes$y[which(nodes$id == "38")], label_top = "o2", label_bottom = "16", style = "double") +
  draw_arrow(nodes$x[which(nodes$id == "38")] + 3, nodes$y[which(nodes$id == "38")], nodes$x[which(nodes$id == "64")] - 3, nodes$y[which(nodes$id == "64")], label_top = "AN", label_bottom = "12", style = "double") +
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 3, nodes$y[which(nodes$id == "1")], nodes$x[which(nodes$id == "6")] - 3, nodes$y[which(nodes$id == "6")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "4")] + 3, nodes$y[which(nodes$id == "4")], nodes$x[which(nodes$id == "9")] - 3, nodes$y[which(nodes$id == "9")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "7")] + 3, nodes$y[which(nodes$id == "7")], nodes$x[which(nodes$id == "12")] - 3, nodes$y[which(nodes$id == "12")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "11")] + 3, nodes$y[which(nodes$id == "11")], nodes$x[which(nodes$id == "15")] - 3, nodes$y[which(nodes$id == "15")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "14")] + 3, nodes$y[which(nodes$id == "14")], nodes$x[which(nodes$id == "18")] - 3, nodes$y[which(nodes$id == "18")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "17")] + 3, nodes$y[which(nodes$id == "17")], nodes$x[which(nodes$id == "21")] - 3, nodes$y[which(nodes$id == "21")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "20")] + 3, nodes$y[which(nodes$id == "20")], nodes$x[which(nodes$id == "24")] - 3, nodes$y[which(nodes$id == "24")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "23")] + 3, nodes$y[which(nodes$id == "23")], nodes$x[which(nodes$id == "27")] - 3, nodes$y[which(nodes$id == "27")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "26")] + 3, nodes$y[which(nodes$id == "26")], nodes$x[which(nodes$id == "30")] - 3, nodes$y[which(nodes$id == "30")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "29")] + 3, nodes$y[which(nodes$id == "29")], nodes$x[which(nodes$id == "36")] - 3, nodes$y[which(nodes$id == "36")], arrowhead = "open", style = "dotdash", color = "red") +
  draw_arrow(nodes$x[which(nodes$id == "35")] + 3, nodes$y[which(nodes$id == "35")], nodes$x[which(nodes$id == "39")] - 3, nodes$y[which(nodes$id == "39")], arrowhead = "open", style = "dotdash", color = "red") +
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 3, nodes$y[which(nodes$id == "1")], 24, -18, arrowhead = "none") +
  draw_arrow(24,-18,nodes$x[which(nodes$id == "3")] - 3, nodes$y[which(nodes$id == "3")], label_top = "C", label_bottom = "45", arrowhead = "open")+
  draw_arrow(nodes$x[which(nodes$id == "3")] + 3, nodes$y[which(nodes$id == "3")], nodes$x[which(nodes$id == "11")] - 3, nodes$y[which(nodes$id == "11")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 3, nodes$y[which(nodes$id == "1")], nodes$x[which(nodes$id == "5")] - 3, nodes$y[which(nodes$id == "5")], label_top = "d2", label_bottom = "13", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "5")] + 3, nodes$y[which(nodes$id == "5")], nodes$x[which(nodes$id == "8")] - 3, nodes$y[which(nodes$id == "8")], label_top = "e2", label_bottom = "24", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "8")] + 3, nodes$y[which(nodes$id == "8")], nodes$x[which(nodes$id == "10")] - 3, nodes$y[which(nodes$id == "10")], label_top = "f1", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "10")] + 3, nodes$y[which(nodes$id == "10")], nodes$x[which(nodes$id == "13")] - 3, nodes$y[which(nodes$id == "13")], label_top = "g1", label_bottom = "19", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "13")] + 3, nodes$y[which(nodes$id == "13")], nodes$x[which(nodes$id == "16")] - 3, nodes$y[which(nodes$id == "16")], label_top = "h1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "16")] + 3, nodes$y[which(nodes$id == "16")], nodes$x[which(nodes$id == "19")] - 3, nodes$y[which(nodes$id == "19")], label_top = "i1", label_bottom = "17", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "19")] + 3, nodes$y[which(nodes$id == "19")], nodes$x[which(nodes$id == "22")] - 3, nodes$y[which(nodes$id == "22")], label_top = "j1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "22")] + 3, nodes$y[which(nodes$id == "22")], nodes$x[which(nodes$id == "25")] - 3, nodes$y[which(nodes$id == "25")], label_top = "k1", label_bottom = "16", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "25")] + 3, nodes$y[which(nodes$id == "25")], nodes$x[which(nodes$id == "28")] - 3, nodes$y[which(nodes$id == "28")], label_top = "l1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "28")] + 3, nodes$y[which(nodes$id == "28")], nodes$x[which(nodes$id == "34")] - 3, nodes$y[which(nodes$id == "34")], label_top = "n1", label_bottom = "14", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "34")] + 3, nodes$y[which(nodes$id == "34")], nodes$x[which(nodes$id == "37")] - 3, nodes$y[which(nodes$id == "37")], label_top = "o1", label_bottom = "15", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "37")] + 3, nodes$y[which(nodes$id == "37")], nodes$x[which(nodes$id == "38")]+3, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "19")] + 3, nodes$y[which(nodes$id == "19")], 145, nodes$y[which(nodes$id == "51")], arrowhead = "none") +
  draw_arrow(145, nodes$y[which(nodes$id == "51")], nodes$x[which(nodes$id == "51")] - 3, nodes$y[which(nodes$id == "51")], label_top = "AA", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "51")] + 3, nodes$y[which(nodes$id == "51")], nodes$x[which(nodes$id == "52")] - 3, nodes$y[which(nodes$id == "52")], label_top = "AB", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "52")] + 3, nodes$y[which(nodes$id == "52")], nodes$x[which(nodes$id == "53")] - 3, nodes$y[which(nodes$id == "53")], label_top = "AC", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "53")] + 3, nodes$y[which(nodes$id == "53")], nodes$x[which(nodes$id == "54")] - 3, nodes$y[which(nodes$id == "54")], label_top = "AD", label_bottom = "26", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "54")] + 3, nodes$y[which(nodes$id == "54")], nodes$x[which(nodes$id == "38")] + 3, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "14")] + 3, nodes$y[which(nodes$id == "14")], 105,-60, label_top = "R", label_bottom = "25", arrowhead = "none") +
  draw_arrow(105,-60,nodes$x[which(nodes$id == "42")] - 3, nodes$y[which(nodes$id == "42")],label_top = "R", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "42")] + 3, nodes$y[which(nodes$id == "42")], nodes$x[which(nodes$id == "43")] - 3, nodes$y[which(nodes$id == "43")], label_top = "S", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "43")] + 3, nodes$y[which(nodes$id == "43")], nodes$x[which(nodes$id == "44")] - 3, nodes$y[which(nodes$id == "44")], label_top = "T", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "44")] + 3, nodes$y[which(nodes$id == "44")], nodes$x[which(nodes$id == "45")] - 3, nodes$y[which(nodes$id == "45")], label_top = "U", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "45")] + 3, nodes$y[which(nodes$id == "45")], nodes$x[which(nodes$id == "46")] - 3, nodes$y[which(nodes$id == "46")], label_top = "V", label_bottom = "25", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "46")] + 3, nodes$y[which(nodes$id == "46")], nodes$x[which(nodes$id == "38")], nodes$y[which(nodes$id == "38")]-3, style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "42")] + 3, nodes$y[which(nodes$id == "42")], 129.5, -51, arrowhead = "none") +
  draw_arrow(129.5,-51, nodes$x[which(nodes$id == "41")] - 3, nodes$y[which(nodes$id == "41")], label_top = "Q", label_bottom = "28", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "41")] + 3, nodes$y[which(nodes$id == "41")], nodes$x[which(nodes$id == "46")] - 3, nodes$y[which(nodes$id == "46")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "45")] + 3, nodes$y[which(nodes$id == "45")], 197.5, -69, arrowhead = "none") +
  draw_arrow(197.5,-69,nodes$x[which(nodes$id == "63")] - 3, nodes$y[which(nodes$id == "63")], label_top = "AM", label_bottom = "40", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "63")] + 3, nodes$y[which(nodes$id == "63")], nodes$x[which(nodes$id == "64")] - 3, nodes$y[which(nodes$id == "64")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "14")] + 3, nodes$y[which(nodes$id == "14")] - 3, 108.5, -33, arrowhead = "none") +
  draw_arrow(108.5,-33,nodes$x[which(nodes$id == "61")]-3, nodes$y[which(nodes$id == "61")], label_top = "AK", label_bottom = "28", bend_at = list(x = 43, y = -40), arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "61")] + 3, nodes$y[which(nodes$id == "61")], nodes$x[which(nodes$id == "50")] - 3, nodes$y[which(nodes$id == "50")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "20")] + 3, nodes$y[which(nodes$id == "20")], 145, nodes$y[which(nodes$id == "55")], arrowhead = "none") +
  draw_arrow(145,nodes$y[which(nodes$id == "55")],nodes$x[which(nodes$id == "55")] - 3, nodes$y[which(nodes$id == "55")], label_top = "AE", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "55")] + 3, nodes$y[which(nodes$id == "55")], nodes$x[which(nodes$id == "56")] - 3, nodes$y[which(nodes$id == "56")], label_top = "AF", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "56")] + 3, nodes$y[which(nodes$id == "56")], nodes$x[which(nodes$id == "57")] - 3, nodes$y[which(nodes$id == "57")], label_top = "AG", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "57")] + 3, nodes$y[which(nodes$id == "57")], nodes$x[which(nodes$id == "58")] - 3, nodes$y[which(nodes$id == "58")], label_top = "AH", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "58")] + 3, nodes$y[which(nodes$id == "58")], nodes$x[which(nodes$id == "38")]+3, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "20")] + 3, nodes$y[which(nodes$id == "20")], nodes$x[which(nodes$id == "47")] - 3, nodes$y[which(nodes$id == "47")], label_top = "W", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "47")] + 3, nodes$y[which(nodes$id == "47")], nodes$x[which(nodes$id == "48")] - 3, nodes$y[which(nodes$id == "48")], label_top = "X", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "48")] + 3, nodes$y[which(nodes$id == "48")], nodes$x[which(nodes$id == "49")] - 3, nodes$y[which(nodes$id == "49")], label_top = "Y", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "49")] + 3, nodes$y[which(nodes$id == "49")], nodes$x[which(nodes$id == "50")] - 3, nodes$y[which(nodes$id == "50")], label_top = "Z", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "50")] + 3, nodes$y[which(nodes$id == "50")], nodes$x[which(nodes$id == "38")], nodes$y[which(nodes$id == "38")]-3, style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "23")] + 3, nodes$y[which(nodes$id == "23")], 171, 36, arrowhead = "none") +
  draw_arrow(171, 36,nodes$x[which(nodes$id == "62")] - 3, nodes$y[which(nodes$id == "62")], label_top = "AL", label_bottom = "45", arrowhead = "open") +

  draw_arrow(nodes$x[which(nodes$id == "23")] + 3, nodes$y[which(nodes$id == "23")], 172, nodes$y[which(nodes$id == "31")], arrowhead = "none") +
  draw_arrow(172, nodes$y[which(nodes$id == "31")], nodes$x[which(nodes$id == "31")]-3, nodes$y[which(nodes$id == "31")], label_top = "m1", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "31")] + 3, nodes$y[which(nodes$id == "31")], nodes$x[which(nodes$id == "32")] - 3, nodes$y[which(nodes$id == "32")], label_top = "m2", label_bottom = "30", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "32")] + 3, nodes$y[which(nodes$id == "32")], nodes$x[which(nodes$id == "33")] - 3, nodes$y[which(nodes$id == "33")], label_top = "m3", label_bottom = "3", arrowhead = "open") +
  
  draw_arrow(nodes$x[which(nodes$id == "26")] + 3, nodes$y[which(nodes$id == "26")], 194, 27, arrowhead = "none") +
  draw_arrow(194, 27, nodes$x[which(nodes$id == "60")]-3, nodes$y[which(nodes$id == "60")], label_top = "AJ", label_bottom = "38", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "60")] + 3, nodes$y[which(nodes$id == "60")], nodes$x[which(nodes$id == "38")]+3, nodes$y[which(nodes$id == "38")], style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "26")] + 3, nodes$y[which(nodes$id == "26")], 200, 21, arrowhead = "none") +
  draw_arrow(200, 21, nodes$x[which(nodes$id == "59")] - 3, nodes$y[which(nodes$id == "59")], label_top = "AI", label_bottom = "21", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "59")] + 3, nodes$y[which(nodes$id == "59")], nodes$x[which(nodes$id == "38")], nodes$y[which(nodes$id == "38")]+3, style = "dashed", arrowhead = "none") +
  
  draw_arrow(nodes$x[which(nodes$id == "35")] + 3, nodes$y[which(nodes$id == "35")], nodes$x[which(nodes$id == "40")] - 3, nodes$y[which(nodes$id == "40")], label_top = "P", label_bottom = "8", arrowhead = "open") +
  draw_arrow(nodes$x[which(nodes$id == "40")] + 3, nodes$y[which(nodes$id == "40")], nodes$x[which(nodes$id == "38")], nodes$y[which(nodes$id == "38")]+3, style = "dashed", arrowhead = "none")+
  
  draw_arrow(nodes$x[which(nodes$id == "1")] + 3, nodes$y[which(nodes$id == "1")], 27, -81, style = "solid", arrowhead = "none")+
  draw_arrow(27, -81, nodes$x[which(nodes$id == "2")] - 3, nodes$y[which(nodes$id == "2")], label_top = "B", label_bottom = "263", arrowhead = "open")+
  draw_arrow(nodes$x[which(nodes$id == "2")] + 3, nodes$y[which(nodes$id == "2")], nodes$x[which(nodes$id == "64")] - 3, nodes$y[which(nodes$id == "64")], style = "dashed", arrowhead = "none")

  
  #Tabel
  isi <- matrix(c("d3", "21", "18", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)

  p <- p + draw_box_grid(center_x = 24, center_y = 12,
                       values = isi,
                       fontface_matrix = bold,
                       box_size = 6,
                       text_size = 1)
  isi <- matrix(c("e3", "24", "21", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 39, center_y = -6,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("d3", "21", "18", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 62, center_y = 9,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("g3", "21", "18", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 79, center_y = -12,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("h3", "30", "27", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 99, center_y = 9,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("i3", "21", "18", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 119, center_y = -12,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("j3", "30", "27", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 142, center_y = 9,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("k3", "21", "18", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 164, center_y = 9,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("l3", "30", "27", "3"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 182, center_y = -6,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("n3", "14", "12", "2"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 199, center_y = 6,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
  isi <- matrix(c("03", "16", "14", "2"), nrow = 2, byrow = TRUE)
  bold <- matrix(c("bold", "plain", "plain", "plain"), nrow = 2, byrow = TRUE)
  
  p <- p + draw_box_grid(center_x = 219, center_y = 6,
                         values = isi,
                         fontface_matrix = bold,
                         box_size = 6,
                         text_size = 1)
# Tampilkan plot
print(p)
